# ERP para Logística - Plan de Proyecto (TDA Admin App)

Este documento resume la arquitectura, tecnologías y plan de desarrollo para el ERP de la empresa de logística de carga pesada.

---

## 1. Stack Tecnológico y Decisiones Clave

- **Hosting:** Namecheap Shared Hosting.
- **Backend:** Laravel (PHP).
- **Base de Datos:** MySQL.
- **Frontend:** Pila TALL (Tailwind CSS, Alpine.js, Laravel, **Livewire 3**).
    - Configuración de Livewire: Layout por defecto `layouts.app` en `config/livewire.php`.
    - Alpine.js: Importación duplicada eliminada de `resources/js/app.js` (gestionado por Livewire).
- **Autenticación (Login/Registro):** **Laravel Breeze** con el stack de Blade.
- **Autorización (Roles y Permisos):** Paquete **`spatie/laravel-permission`** (Modelo RBAC).
- **Convenciones:** Todos los nombres de tablas y columnas en la base de datos se escribirán en **inglés**.
- **Auditoría:** Implementado un Trait `Auditable` para `created_by`, `updated_by`, `deleted_by` en modelos.
- **Borrado Lógico:** Implementado `SoftDeletes` en modelos y migraciones.
- **Almacenamiento de Archivos:** `php artisan storage:link` configurado para `public/storage`.
- **Localización:** Idioma por defecto configurado a `es` en `config/app.php`. Archivo `resources/lang/es.json` creado y poblado con todas las traducciones de la UI.

---

## 2. Arquitectura de Base de Datos y Modelos

### Relación Usuario-Empleado
- La tabla `employees` tiene una columna `user_id` (FK nulable) a la tabla `users`.

### Modelo de Personal (HR)
- Tabla central `employees` (`first_name`, `last_name`, `document_number`, `email`, `hire_date`, `status`, `user_id`).
- `Employee` model usa `Auditable` y `SoftDeletes`.
- Tablas de perfiles (`driver_profiles`, `administrative_profiles`) para datos específicos (pendientes de creación).

### Modelo de Flota
- Tabla central `vehicles` (`name`, `plate_number`, `brand`, `model`, `year`, `vin`, `status`, `vehicle_type_id`).
- `Vehicle` model usa `Auditable` y `SoftDeletes`.
- **Nueva tabla `vehicle_types`:** (`id`, `name`) para tipos de vehículo configurables.
- **Nueva tabla `maintenance_types`:** (`id`, `name`, `category`, `description`) para tipos de mantenimiento configurables.
- **Nueva tabla `maintenance_records`:** (`id`, `vehicle_id`, `maintenance_type_id`, `description`, `date`, `cost`, `performed_by`, `notes`, `next_service_date`, `odometer_reading`) para registrar mantenimientos.
- Tablas de perfiles (`tractor_truck_details`, `trailer_details`) creadas.
    - `tractor_truck_details`: `vehicle_id`, `towing_capacity_tons`, `engine_specs`.
    - `trailer_details`: `vehicle_id`, `load_capacity_tons`, `dimensions_meters`, `axle_count`.

### Modelo de Clientes
- Tabla `customers` (`name`, `contact_person`, `email`, `phone_number`, `address`, `tax_id`, `status`).
- `Customer` model usa `Auditable` y `SoftDeletes`.

### Modelo de Operaciones Complejas
- **Nueva tabla `trips`:** (`id`, `driver_id`, `tractor_id`, `trailer_id`, `start_date`, `end_date`, `start_odometer_tractor`, `end_odometer_tractor`, `origin`, `destination`, `status`, `notes`).
    - `Trip` model usa `Auditable` y `SoftDeletes`.
- **Nueva tabla `shipments`:** (`id`, `trip_id`, `customer_id`, `description`, `weight_tons`, `volume_m3`, `pickup_address`, `pickup_latitude`, `pickup_longitude`, `delivery_address`, `delivery_latitude`, `delivery_longitude`, `status`, `notes`).
    - `Shipment` model usa `Auditable` y `SoftDeletes`.
- Tabla `shipping_operations` para actuar como un "proyecto" que agrupa todos los recursos de un envío complejo (ej. carga sobredimensionada) (pendiente de creación).
- Tabla pivote polimórfica `operation_resources` para asignar un número ilimitado de recursos (`Vehicle`, `Employee`, `ThirdPartyProvider`) a una `shipping_operation`, cada uno con un `role` descriptivo (pendiente de creación).
- Tabla `third_party_providers` para gestionar socios externos (pendiente de creación).

### Gestión Centralizada de Documentos
- Tabla `documents` (`name`, `description`, `file_path`, `issue_date`, `expiry_date`, `status`).
- `Document` model usa `Auditable` y `SoftDeletes`.
- Relación polimórfica (`documentable_id`, `documentable_type`) para vincular documentos a `Employees`, `Vehicles`, etc.

---

## 3. Módulos del Sistema (Estado Actual)

- **Dashboard:**
    - **Tarjetas de Resumen:** Muestra conteos de documentos vencidos, por vencer, empleados activos y vehículos operativos.
    - **Tablas de Documentos:** Muestra documentos vencidos y próximos a vencer.
    - **Enlaces de Acción Mejorados:** Los enlaces "Gestionar Documentos" ahora abren directamente el modal de gestión de documentos del recurso específico (empleado/vehículo).
    - **Botones con Iconos:** Los botones de acción en las tablas han sido reemplazados por iconos para una mejor UI.
- **1. Gestión Comercial (CRM):**
    - **Clientes (`Customers`):** CRUD completo implementado (Listado, Crear, Editar, Eliminar Lógico/Forzado, Restaurar).
- **2. Operaciones y Despacho:**
    - **Viajes (`Trips`):** Módulo CRUD básico para la gestión de viajes (pendiente de implementación).
    - **Envíos (`Shipments`):** Módulo CRUD básico para la gestión de envíos/cargas, incluyendo coordenadas geográficas (pendiente de implementación).
- **3. Gestión de Flota:**
    - **Vehículos (`Vehicles`):** CRUD completo implementado (Listado, Crear, Editar, Eliminar Lógico/Forzado, Restaurar).
    - **Gestión de Tipos de Vehículo:** Nuevo módulo CRUD para definir y administrar tipos de vehículo (`/settings/vehicle-types`). El formulario de vehículos ahora usa estos tipos dinámicamente.
    - **Gestión de Documentos para Vehículos:** Interfaz para listar, añadir, editar y eliminar documentos de un vehículo específico.
    - **Gestión de Mantenimiento de Vehículos:** Módulo CRUD para registrar mantenimientos (preventivos, correctivos, cambio de piezas) por vehículo. Incluye gestión de tipos de mantenimiento configurables (`/settings/maintenance-types`).
- **4. Facturación y Finanzas:** (Pendiente de implementación)
- **5. Gestión de Personal (HR):**
    - **Empleados (`Employees`):** CRUD completo implementado (Listado, Crear, Editar, Eliminar Lógico/Forzado, Restaurar).
    - **Gestión de Documentos para Empleados:** Interfaz para listar, añadir, editar y eliminar documentos de un empleado específico.
- **6. Portal de Clientes:** (Pendiente de implementación)

---

## 4. Notificaciones Proactivas

- **Comando de Artisan:** `documents:check-expiring` creado para revisar documentos próximos a vencer.
- **Scheduler de Laravel:** Configurado para ejecutar `documents:check-expiring` diariamente.
- **Sistema de Notificación:** **Integración de envío de emails configurada.** Pendiente de widget en Dashboard.

---

## 5. Próximos Pasos

1.  **Implementar perfiles específicos para Empleados (Conductores y Administrativos):** Crear tablas `driver_profiles` y `administrative_profiles` e integrarlas en el módulo de empleados.
2.  **Comenzar con el módulo de Operaciones y Despacho:**
    *   Implementar el módulo de Viajes (`Trips`) con su CRUD básico.
    *   Implementar el módulo de Envíos (`Shipments`) con su CRUD básico.
    *   Crear la tabla `shipping_operations` y su CRUD básico.
3.  **Módulo de Terceros Proveedores:** Crear la tabla `third_party_providers` y su CRUD.
4.  Continuar con la implementación de los módulos restantes del MVP (Facturación, Portal de Clientes, etc.).