<?php

namespace App\Livewire\Forms;

use App\Models\Vehicle;
use Illuminate\Validation\Rule as ValidationRule;
use Livewire\Form;

class VehicleForm extends Form
{
    public ?Vehicle $vehicle = null;

    public $name = '';

    public $plate_number = '';

    public $brand = '';

    public $model = '';

    public $year = null;

    public $vin = null;

    public $status = 'operational';

    public $vehicle_type_id = null; // Changed from vehicle_type

    public function setVehicle(Vehicle $vehicle)
    {
        $this->vehicle = $vehicle;
        $this->name = $vehicle->name;
        $this->plate_number = $vehicle->plate_number;
        $this->brand = $vehicle->brand;
        $this->model = $vehicle->model;
        $this->year = $vehicle->year;
        $this->vin = $vehicle->vin;
        $this->status = $vehicle->status;
        $this->vehicle_type_id = $vehicle->vehicle_type_id; // Changed from vehicle_type
    }

    public function store()
    {
        $validated = $this->validate([
            'name' => 'required|string|max:255',
            'plate_number' => ['required', 'string', 'max:255', ValidationRule::unique('vehicles', 'plate_number')],
            'brand' => 'nullable|string|max:255',
            'model' => 'nullable|string|max:255',
            'year' => 'nullable|integer|min:1900|max:'.(date('Y') + 1),
            'vin' => ['nullable', 'string', 'max:255', ValidationRule::unique('vehicles', 'vin')],
            'status' => 'required|in:operational,in_maintenance,out_of_service',
            'vehicle_type_id' => 'required|exists:vehicle_types,id', // Changed validation
        ]);

        Vehicle::create($validated);
    }

    public function update()
    {
        $validated = $this->validate([
            'name' => 'required|string|max:255',
            'plate_number' => ['required', 'string', 'max:255', ValidationRule::unique('vehicles', 'plate_number')->ignore($this->vehicle->id)],
            'brand' => 'nullable|string|max:255',
            'model' => 'nullable|string|max:255',
            'year' => 'nullable|integer|min:1900|max:'.(date('Y') + 1),
            'vin' => ['nullable', 'string', 'max:255', ValidationRule::unique('vehicles', 'vin')->ignore($this->vehicle->id)],
            'status' => 'required|in:operational,in_maintenance,out_of_service',
            'vehicle_type_id' => 'required|exists:vehicle_types,id', // Changed validation
        ]);

        $this->vehicle->update($validated);
    }
}
