<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection; // Import Collection

class DocumentExpiryNotification extends Mailable
{
    use Queueable, SerializesModels;

    public Collection $expiringDocuments; // Public property to pass data to the view

    /**
     * Create a new message instance.
     */
    public function __construct(Collection $expiringDocuments)
    {
        $this->expiringDocuments = $expiringDocuments;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Notificación de Documentos Próximos a Vencer',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.documents.expiring', // Use a markdown view for better styling
            with: [
                'expiringDocuments' => $this->expiringDocuments,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
