<?php

use App\Models\Vehicle;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trailer_details', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Vehicle::class)->unique()->constrained('vehicles')->onDelete('cascade');
            $table->decimal('load_capacity_tons', 8, 2)->nullable();
            $table->string('dimensions_meters')->nullable(); // e.g., "13.6m x 2.55m x 4.0m"
            $table->unsignedTinyInteger('axle_count')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trailer_details');
    }
};
