@props(['title', 'documents'])

<div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
    <div class="p-6 text-gray-900">
        <h3 class="text-lg font-medium text-gray-900 mb-4">{{ $title }}</h3>

        @if ($documents->isEmpty())
            <p>{{ __('No se encontraron documentos.') }}</p>
        @else
            <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                <table class="w-full text-sm text-left text-gray-500">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3">{{ __('Documento') }}</th>
                            <th scope="col" class="px-6 py-3">{{ __('Asociado a') }}</th>
                            <th scope="col" class="px-6 py-3">
                                @if(Str::contains($title, 'Vencidos'))
                                    {{ __('Venció el') }}
                                @else
                                    {{ __('Vence el') }}
                                @endif
                            </th>
                            <th scope="col" class="px-6 py-3">{{ __('Acciones') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($documents as $document)
                            <tr class="bg-white border-b hover:bg-gray-50">
                                <td class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                    {{ $document->name }}
                                </td>
                                <td class="px-6 py-4">
                                    @if ($document->documentable)
                                        @if ($document->documentable_type === 'App\Models\Employee')
                                            {{ $document->documentable->first_name }} {{ $document->documentable->last_name }}
                                        @elseif ($document->documentable_type === 'App\Models\Vehicle')
                                            {{ $document->documentable->name }}
                                        @else
                                            {{ class_basename($document->documentable_type) }} (ID: {{ $document->documentable_id }})
                                        @endif
                                    @else
                                        <span class="text-red-500">{{ __('Recurso no encontrado') }}</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-red-600 font-bold">
                                    {{ $document->expiry_date->format('Y-m-d') }}
                                </td>
                                <td class="px-6 py-4">
                                                    @if ($document->documentable_type === 'App\Models\Employee')
                                                        <a href="{{ route('employees.index', ['employee_id' => $document->documentable_id]) }}" class="text-blue-600 hover:underline" aria-label="{{ __('Gestionar Documentos') }}"><i class="fa-solid fa-folder-open"></i></a>
                                                    @elseif ($document->documentable_type === 'App\Models\Vehicle')
                                                        <a href="{{ route('vehicles.index', ['vehicle_id' => $document->documentable_id]) }}" class="text-blue-600 hover:underline" aria-label="{{ __('Gestionar Documentos') }}"><i class="fa-solid fa-folder-open"></i></a>
                                                    @endif
                                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
