<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Stat Cards -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mt-6">
            <!-- Expired Documents Card -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h4 class="text-sm font-semibold text-gray-500">{{ __('Documentos Vencidos') }}</h4>
                    <p class="text-3xl font-bold text-red-600 mt-1">{{ $expiredDocumentsCount }}</p>
                </div>
            </div>
            <!-- Expiring Soon Card -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h4 class="text-sm font-semibold text-gray-500">{{ __('Documentos por Vencer (30 días)') }}</h4>
                    <p class="text-3xl font-bold text-orange-500 mt-1">{{ $expiringSoonCount }}</p>
                </div>
            </div>
            <!-- Active Employees Card -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h4 class="text-sm font-semibold text-gray-500">{{ __('Empleados Activos') }}</h4>
                    <p class="text-3xl font-bold text-green-600 mt-1">{{ $activeEmployeesCount }}</p>
                </div>
            </div>
            <!-- Operational Vehicles Card -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h4 class="text-sm font-semibold text-gray-500">{{ __('Vehículos Operativos') }}</h4>
                    <p class="text-3xl font-bold text-blue-600 mt-1">{{ $operationalVehiclesCount }}</p>
                </div>
            </div>
        </div>

        <div class="mt-6">
            <livewire:expiring-documents-widget />
        </div>

        <div class="mt-6">
            <livewire:maintenance-status-widget />
        </div>

        <div class="mt-6">
            <x-document-table :title="__('Documentos Vencidos')" :documents="$expiredDocuments" />
        </div>
    </div>
</x-app-layout>
