<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Customers') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    <div class="flex justify-between mb-4">
                        <div class="flex items-center">
                            <label for="filterStatus" class="mr-2 text-sm font-medium text-gray-700">{{ __('Show:') }}</label>
                            <select wire:model.live="filterStatus" id="filterStatus" class="block w-full rounded-md border-gray-300 shadow-sm text-sm">
                                <option value="active">{{ __('Active') }}</option>
                                <option value="trashed">{{ __('Deleted') }}</option>
                                <option value="all">{{ __('All') }}</option>
                            </select>
                        </div>
                        <button wire:click="create" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            {{ __('Create Customer') }}
                        </button>
                    </div>

                    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                        <table class="w-full text-sm text-left text-gray-500">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3">{{ __('Name') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Contact Person') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Email') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Status') }}</th>
                                    <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Actions') }}</span></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($customers as $customer)
                                    <tr wire:key="{{ $customer->id }}" class="bg-white border-b hover:bg-gray-50 {{ $customer->trashed() ? 'bg-red-50/50' : '' }}">
                                        <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                            {{ $customer->name }}
                                        </th>
                                        <td class="px-6 py-4">{{ $customer->contact_person }}</td>
                                        <td class="px-6 py-4">{{ $customer->email }}</td>
                                        <td class="px-6 py-4">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $customer->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                {{ __('Active') }}
                                            </span>
                                            @if ($customer->trashed())
                                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                    {{ __('Deleted') }}
                                                </span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            @if ($customer->trashed())
                                                <button wire:click="restore({{ $customer->id }})" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded">{{ __('Restore') }}</button>
                                                <button wire:click="forceDelete({{ $customer->id }})" wire:confirm="{{ __('Are you sure you want to permanently delete this customer? This action cannot be undone.') }}" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2">{{ __('Force Delete') }}</button>
                                            @else
                                                <button wire:click="edit({{ $customer->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded">{{ __('Edit') }}</button>
                                                <button wire:click="delete({{ $customer->id }})" wire:confirm="{{ __('Are you sure you want to delete this customer?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2">{{ __('Delete') }}</button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr class="bg-white border-b">
                                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                            {{ __('No customers found.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $customers->links() }}
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    <div
        x-data="{ show: false }"
        x-cloak
        x-on:open-modal.window="show = true"
        x-on:close-modal.window="show = false"
        x-on:keydown.escape.window="show = false"
        x-show="show"
        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
    >
        <div
            x-show="show"
            class="fixed inset-0 transform transition-all"
            x-on:click="show = false"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div
            x-show="show"
            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-2xl sm:mx-auto"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
        >
            <form wire:submit.prevent="save" wire:key="customer-form-{{ $isEditing ? $form->customer->id : 'new' }}">
                <div class="px-6 py-4">
                    <div class="text-lg">
                        {{ $isEditing ? 'Edit Customer' : 'Create Customer' }}
                    </div>

                    <div class="mt-4 space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">{{ __('Name') }}</label>
                                <input wire:model.defer="form.name" id="name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="contact_person" class="block text-sm font-medium text-gray-700">{{ __('Contact Person') }}</label>
                                <input wire:model.defer="form.contact_person" id="contact_person" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.contact_person') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700">{{ __('Email') }}</label>
                            <input wire:model.defer="form.email" id="email" type="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('form.email') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="phone_number" class="block text-sm font-medium text-gray-700">{{ __('Phone Number') }}</label>
                            <input wire:model.defer="form.phone_number" id="phone_number" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('form.phone_number') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="address" class="block text-sm font-medium text-gray-700">{{ __('Address') }}</label>
                            <textarea wire:model.defer="form.address" id="address" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                            @error('form.address') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="tax_id" class="block text-sm font-medium text-gray-700">{{ __('Tax ID') }}</label>
                            <input wire:model.defer="form.tax_id" id="tax_id" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('form.tax_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">{{ __('Status') }}</label>
                            <select wire:model.defer="form.status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <option value="active">{{ __('Active') }}</option>
                                <option value="inactive">{{ __('Inactive') }}</option>
                                <option value="on_hold">{{ __('On Hold') }}</option>
                            </select>
                            @error('form.status') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>

                <div class="bg-gray-100 px-6 py-4 flex justify-end">
                    <button type="button" x-on:click="show = false" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                        {{ __('Cancel') }}
                    </button>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        {{ __('Save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>