<div x-data="{ employeeId: @entangle('employee_id').live }"
     x-init="if (employeeId) { $wire.manageDocuments(employeeId); }">
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Employees') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    <div class="flex justify-between mb-4">
                        <div class="flex items-center">
                            <label for="filterStatus" class="mr-2 text-sm font-medium text-gray-700">{{ __('Show:') }}</label>
                            <select wire:model.live="filterStatus" id="filterStatus" class="block w-full rounded-md border-gray-300 shadow-sm text-sm">
                                <option value="active">{{ __('Active') }}</option>
                                <option value="trashed">{{ __('Deleted') }}</option>
                                <option value="all">{{ __('All') }}</option>
                            </select>
                        </div>
                        <div class="w-auto">
                            <button wire:click="create" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded" aria-label="{{ __('Create Employee') }}">
                                <i class="fa-solid fa-plus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                        <table class="w-full text-sm text-left text-gray-500">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3">{{ __('Name') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Email') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Employee Type') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Status') }}</th>
                                    <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Actions') }}</span></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($employees as $employee)
                                    <tr wire:key="{{ $employee->id }}" class="bg-white border-b hover:bg-gray-50 {{ $employee->trashed() ? 'bg-red-50/50' : '' }}">
                                        <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                            {{ $employee->first_name }} {{ $employee->last_name }}
                                        </th>
                                        <td class="px-6 py-4">{{ $employee->email }}</td>
                                        <td class="px-6 py-4">{{ $employee->employee_type }}</td>
                                        <td class="px-6 py-4">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $employee->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                {{ $employee->status }}
                                            </span>
                                            @if ($employee->trashed())
                                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                    {{ __('Deleted') }}
                                                </span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            @if ($employee->trashed())
                                                <button wire:click="restore({{ $employee->id }})" wire:confirm="{{ __('Are you sure you want to restore this employee?') }}" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Restore') }}"><i class="fa-solid fa-undo"></i></button>
                                                <button wire:click="forceDelete({{ $employee->id }})" wire:confirm="{{ __('Are you sure you want to permanently delete this employee? This action cannot be undone.') }}" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Force Delete') }}"><i class="fa-solid fa-times-circle"></i></button>
                                            @else
                                                <button wire:click="manageDocuments({{ $employee->id }})" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Manage Documents') }}"><i class="fa-solid fa-folder-open"></i></button>
                                                <button wire:click="edit({{ $employee->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Edit') }}"><i class="fa-solid fa-edit"></i></button>
                                                <button wire:click="delete({{ $employee->id }})" wire:confirm="{{ __('Are you sure you want to delete this employee?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Delete') }}"><i class="fa-solid fa-trash"></i></button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr class="bg-white border-b">
                                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                            {{ __('No employees found.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $employees->links() }}
                    </div>

                    <!-- Create/Edit Employee Modal -->
                    <div
                        x-data="{ show: false }"
                        x-cloak
                        x-on:open-modal.window="show = true"
                        x-on:close-modal.window="show = false"
                        x-on:keydown.escape.window="show = false"
                        x-show="show"
                        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
                    >
                        <div
                            x-show="show"
                            class="fixed inset-0 transform transition-all"
                            x-on:click="$dispatch('close-modal')"
                            x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0"
                            x-transition:enter-end="opacity-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100"
                            x-transition:leave-end="opacity-0"
                        >
                            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                        </div>

                        <div
                            x-show="show"
                            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-2xl sm:mx-auto"
                            x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                        >
                            <form wire:submit.prevent="save" wire:key="employee-form-{{ $isEditing ? $form->employee->id : 'new' }}">
                                <div class="px-6 py-4">
                                    <div class="text-lg">
                                        {{ $isEditing ? __('Edit Employee') : __('Create Employee') }}
                                    </div>

                                    <div class="mt-4 space-y-4">
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <label for="first_name" class="block text-sm font-medium text-gray-700">{{ __('First Name') }}</label>
                                                <input wire:model.defer="form.first_name" id="first_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                @error('form.first_name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                            </div>
                                            <div>
                                                <label for="last_name" class="block text-sm font-medium text-gray-700">{{ __('Last Name') }}</label>
                                                <input wire:model.defer="form.last_name" id="last_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                @error('form.last_name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                            </div>
                                        </div>
                                        <div>
                                            <label for="email" class="block text-sm font-medium text-gray-700">{{ __('Email') }}</label>
                                            <input wire:model.defer="form.email" id="email" type="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            @error('form.email') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                        </div>
                                        <div>
                                            <label for="document_number" class="block text-sm font-medium text-gray-700">{{ __('Document Number') }}</label>
                                            <input wire:model.defer="form.document_number" id="document_number" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            @error('form.document_number') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <label for="employee_type" class="block text-sm font-medium text-gray-700">{{ __('Employee Type') }}</label>
                                                <select wire:model.defer="form.employee_type" id="employee_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                    <option value="driver">{{ __('Driver') }}</option>
                                                    <option value="administrative">{{ __('Administrative') }}</option>
                                                </select>
                                                @error('form.employee_type') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                            </div>
                                            <div>
                                                <label for="status" class="block text-sm font-medium text-gray-700">{{ __('Status') }}</label>
                                                <select wire:model.defer="form.status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                    <option value="active">{{ __('Active') }}</option>
                                                    <option value="on_leave">{{ __('On Leave') }}</option>
                                                    <option value="terminated">{{ __('Terminated') }}</option>
                                                </select>
                                                @error('form.status') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                            </div>
                                        </div>
                                        <div>
                                            <label for="hire_date" class="block text-sm font-medium text-gray-700">{{ __('Hire Date') }}</label>
                                            <input wire:model.defer="form.hire_date" id="hire_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            @error('form.hire_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                    </div>

                                    <div class="bg-gray-100 px-6 py-4 flex justify-end">
                                        <button type="button" x-on:click="show = false" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                                            {{ __('Cancel') }}
                                        </button>
                                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                            {{ __('Save') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
    <!-- Document Management Modal -->
    <div
        x-data="{ show: false }"
        x-cloak
        x-on:open-document-form-modal.window="show = true"
        x-on:close-document-form-modal.window="show = false"
        x-on:keydown.escape.window="show = false"
        x-show="show"
        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
    >
        <div
            x-show="show"
            class="fixed inset-0 transform transition-all"
            x-on:click="show = false"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div
            x-show="show"
            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-3xl sm:mx-auto"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-4 sm:scale-95"
        >
            <form wire:submit.prevent="saveDocument" wire:key="document-form-{{ $documentForm->document && $documentForm->document->exists ? $documentForm->document->id : 'new' }}">
                <div class="px-6 py-4">
                    <div class="text-lg">
                        {{ $documentForm->document && $documentForm->document->exists ? __('Edit Document') : __('Create Document') }}
                        @if ($this->currentEmployee)
                            ({{ __('for') }} {{ $this->currentEmployee->first_name }} {{ $this->currentEmployee->last_name }})
                        @endif
                    </div>

                    <div class="mt-4 space-y-4">
                        <div>
                            <label for="document_name" class="block text-sm font-medium text-gray-700">{{ __('Document Name') }}</label>
                            <input wire:model.defer="documentForm.name" id="document_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('documentForm.name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="document_description" class="block text-sm font-medium text-gray-700">{{ __('Description') }}</label>
                            <textarea wire:model.defer="documentForm.description" id="document_description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                            @error('documentForm.description') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="document_file" class="block text-sm font-medium text-gray-700">{{ __('File') }}</label>
                            <input wire:model="documentForm.file" id="document_file" type="file" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('documentForm.file') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            @if ($documentForm->file_path && !$documentForm->file)
                                <p class="text-sm text-gray-500 mt-1">{{ __('Current file:') }} <a href="{{ Storage::url($documentForm->file_path) }}" target="_blank" class="text-blue-600 hover:underline">{{ basename($documentForm->file_path) }}</a></p>
                            @endif
                        </div>
                        <div>
                            <label for="document_url" class="block text-sm font-medium text-gray-700">{{ __('Or URL') }}</label>
                            <input wire:model.defer="documentForm.file_path" id="document_url" type="url" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="https://example.com/document.pdf">
                            @error('documentForm.file_path') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="document_issue_date" class="block text-sm font-medium text-gray-700">{{ __('Issue Date') }}</label>
                                <input wire:model.defer="documentForm.issue_date" id="document_issue_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('documentForm.issue_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="document_expiry_date" class="block text-sm font-medium text-gray-700">{{ __('Expiry Date') }}</label>
                                <input wire:model.defer="documentForm.expiry_date" id="document_expiry_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('documentForm.expiry_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div>
                            <label for="document_status" class="block text-sm font-medium text-gray-700">{{ __('Status') }}</label>
                            <select wire:model.defer="documentForm.status" id="document_status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <option value="valid">{{ __('Valid') }}</option>
                                <option value="expired">{{ __('Expired') }}</option>
                                <option value="pending_review">{{ __('Pending Review') }}</option>
                            </select>
                            @error('documentForm.status') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>

                <div class="bg-gray-100 px-6 py-4 flex justify-end">
                    <button type="button"                             x-on:click="$dispatch('close-modal')" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                        {{ __('Cancel') }}
                    </button>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        {{ __('Save Document') }}
                    </button>
                </div>
            </form>

            <div class="p-6 text-gray-900 border-t mt-4">
                <h3 class="text-lg font-medium text-gray-900 mb-4">{{ __('Employee Documents') }}</h3>
                <div class="flex justify-end mb-4">
                    <button wire:click="createDocument" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        {{ __('Add Document') }}
                    </button>
                </div>
                <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                    <table class="w-full text-sm text-left text-gray-500">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3">{{ __('Document Name') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Issue Date') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Expiry Date') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Status') }}</th>
                                <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Actions') }}</span></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($employeeDocuments as $document)
                                <tr wire:key="document-{{ $document->id }}" class="bg-white border-b hover:bg-gray-50 {{ $document->trashed() ? 'bg-red-50/50' : '' }}">
                                    <td class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                        <a href="{{ Storage::url($document->file_path) }}" target="_blank" class="text-blue-600 hover:underline">{{ $document->name }}</a>
                                    </td>
                                    <td class="px-6 py-4">{{ $document->issue_date?->format('Y-m-d') }}</td>
                                    <td class="px-6 py-4 {{ $document->expiry_date?->isPast() ? 'text-red-600 font-bold' : '' }}">
                                        {{ $document->expiry_date?->format('Y-m-d') }}
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $document->status === 'valid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ $document->status }}
                                        </span>
                                        @if ($document->trashed())
                                            <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                {{ __('Deleted') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 text-right">
                                        @if ($document->trashed())
                                            <button wire:click="restoreDocument({{ $document->id }})" wire:confirm="{{ __('Are you sure you want to restore this document?') }}" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded">{{ __('Restore') }}</button>
                                            <button wire:click="forceDeleteDocument({{ $document->id }})" wire:confirm="{{ __('Are you sure you want to permanently delete this document? This action cannot be undone.') }}" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2">{{ __('Force Delete') }}</button>
                                        @else
                                            <button wire:click="editDocument({{ $document->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded">{{ __('Edit') }}</button>
                                            <button wire:click="deleteDocument({{ $document->id }})" wire:confirm="{{ __('Are you sure you want to delete this document?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2">{{ __('Delete') }}</button>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr class="bg-white border-b">
                                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                        {{ __('No documents found for this employee.') }}
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
                </div>
            </div>
        </div>
    </div>
</div>