@use('Illuminate\Support\Number')
<div class="p-6 bg-white border-b border-gray-200 sm:rounded-lg shadow-sm">
    <h3 class="text-2xl font-semibold text-gray-800 mb-6">Resumen de Mantenimiento</h3>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Due by Odometer -->
        <div>
            <h4 class="text-lg font-medium text-gray-700 mb-4">Servicios por Odómetro</h4>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left text-gray-500">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-3">Vehículo</th>
                            <th scope="col" class="px-4 py-3">Odómetro Actual</th>
                            <th scope="col" class="px-4 py-3">Próximo Servicio</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($this->dueServicesByOdometer as $record)
                            <tr wire:key="odo-{{ $record->id }}" class="bg-white border-b hover:bg-gray-50">
                                <td class="px-4 py-3 font-medium text-gray-900">
                                    <a href="{{ route('vehicles.index', ['vehicle_id' => $record->vehicle_id]) }}" class="text-blue-600 hover:underline">
                                        {{ $record->vehicle->name }}
                                    </a>
                                </td>
                                <td class="px-4 py-3 font-bold text-red-600">{{ Number::format($record->vehicle->current_odometer) }} km</td>
                                <td class="px-4 py-3">{{ Number::format($record->next_service_odometer) }} km</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="px-4 py-3 text-center text-gray-500">No hay servicios por odómetro.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Overdue by Date -->
        <div>
            <h4 class="text-lg font-medium text-gray-700 mb-4">Servicios Vencidos por Fecha</h4>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left text-gray-500">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-3">Vehículo</th>
                            <th scope="col" class="px-4 py-3">Fecha de Vencimiento</th>
                            <th scope="col" class="px-4 py-3">Días Vencido</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($this->overdueServicesByDate as $record)
                            <tr wire:key="overdue-{{ $record->id }}" class="bg-white border-b hover:bg-gray-50">
                                <td class="px-4 py-3 font-medium text-gray-900">
                                    <a href="{{ route('vehicles.index', ['vehicle_id' => $record->vehicle_id]) }}" class="text-blue-600 hover:underline">
                                        {{ $record->vehicle->name }}
                                    </a>
                                </td>
                                <td class="px-4 py-3">{{ $record->next_service_date->format('Y-m-d') }}</td>
                                <td class="px-4 py-3 font-bold text-red-600">{{ $record->next_service_date->diffInDays(now()) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="px-4 py-3 text-center text-gray-500">No hay servicios vencidos.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Upcoming by Date -->
        <div class="lg:col-span-2">
            <h4 class="text-lg font-medium text-gray-700 mb-4">Próximos Servicios por Fecha (30 días)</h4>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left text-gray-500">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-3">Vehículo</th>
                            <th scope="col" class="px-4 py-3">Fecha de Vencimiento</th>
                            <th scope="col" class="px-4 py-3">Días Restantes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($this->upcomingServicesByDate as $record)
                            <tr wire:key="upcoming-{{ $record->id }}" class="bg-white border-b hover:bg-gray-50">
                                <td class="px-4 py-3 font-medium text-gray-900">
                                    <a href="{{ route('vehicles.index', ['vehicle_id' => $record->vehicle_id]) }}" class="text-blue-600 hover:underline">
                                        {{ $record->vehicle->name }}
                                    </a>
                                </td>
                                <td class="px-4 py-3">{{ $record->next_service_date->format('Y-m-d') }}</td>
                                <td class="px-4 py-3 font-semibold text-yellow-600">{{ $record->next_service_date->diffInDays(now()) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="px-4 py-3 text-center text-gray-500">No hay servicios próximos.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>