<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Vehicle Types') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    <div class="flex justify-end mb-4">
                        <button wire:click="create" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded" aria-label="{{ __('Create Vehicle Type') }}">
                            <i class="fa-solid fa-plus"></i>
                        </button>
                    </div>

                    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                        <table class="w-full text-sm text-left text-gray-500">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3">{{ __('Name') }}</th>
                                    <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Actions') }}</span></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($vehicleTypes as $vehicleType)
                                    <tr wire:key="{{ $vehicleType->id }}" class="bg-white border-b hover:bg-gray-50">
                                        <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                            {{ $vehicleType->name }}
                                        </th>
                                        <td class="px-6 py-4 text-right">
                                            <button wire:click="edit({{ $vehicleType->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Edit') }}"><i class="fa-solid fa-edit"></i></button>
                                            <button wire:click="delete({{ $vehicleType->id }})" wire:confirm="{{ __('Are you sure you want to delete this vehicle type?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Delete') }}"><i class="fa-solid fa-trash"></i></button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr class="bg-white border-b">
                                        <td colspan="2" class="px-6 py-4 text-center text-gray-500">
                                            {{ __('No vehicle types found.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $vehicleTypes->links() }}
                    </div>

                    <!-- Create/Edit Vehicle Type Modal -->
                    <div
                        x-data="{ show: false }"
                        x-cloak
                        x-on:open-modal.window="show = true"
                        x-on:close-modal.window="show = false"
                        x-on:keydown.escape.window="show = false"
                        x-show="show"
                        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
                    >
                        <div
                            x-show="show"
                            class="fixed inset-0 transform transition-all"
                            x-on:click="$dispatch('close-modal')"
                            x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0"
                            x-transition:enter-end="opacity-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100"
                            x-transition:leave-end="opacity-0"
                        >
                            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                        </div>

                        <div
                            x-show="show"
                            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-2xl sm:mx-auto"
                            x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                        >
                            <form wire:submit.prevent="save">
                                <div class="px-6 py-4">
                                    <div class="text-lg">
                                        {{ $isEditing ? __('Edit Vehicle Type') : __('Create Vehicle Type') }}
                                    </div>

                                    <div class="mt-4 space-y-4">
                                        <div>
                                            <label for="name" class="block text-sm font-medium text-gray-700">{{ __('Name') }}</label>
                                            <input wire:model.defer="name" id="name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            @error('name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="bg-gray-100 px-6 py-4 flex justify-end">
                                    <button type="button" x-on:click="$dispatch('close-modal')" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                                        {{ __('Cancel') }}
                                    </button>
                                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                        {{ __('Save') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>