<?php

use App\Http\Controllers\ProfileController;
use App\Livewire\Customer\Index as CustomerIndex;
use App\Livewire\Employee\Index as EmployeeIndex;
use App\Livewire\Settings\MaintenanceTypeIndex;
use App\Livewire\Settings\VehicleTypeIndex; // Import CustomerIndex
use App\Livewire\Vehicle\Index as VehicleIndex;
use App\Livewire\Trip\Index as TripIndex; // Add this line
use App\Models\Document;
use App\Models\Employee;
use App\Models\Vehicle;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('dashboard', function () {
    // Data for Stat Cards
    $expiredDocumentsCount = Document::where('expiry_date', '<', now())
        ->whereHas('documentable', fn ($q) => $q->whereNull('deleted_at'))
        ->count();

    $expiringSoonCount = Document::where('expiry_date', '!=', null)
        ->where('expiry_date', '<=', now()->addDays((int) config('documents.expiry_threshold_days', 30)))
        ->where('expiry_date', '>=', now())
        ->where('status', 'valid')
        ->whereHas('documentable', fn ($q) => $q->whereNull('deleted_at'))
        ->count();

    $activeEmployeesCount = Employee::where('status', 'active')->count();
    $operationalVehiclesCount = Vehicle::where('status', 'operational')->count();

    // Data for Expired Documents Table
    $expiredDocuments = Document::with('documentable')
        ->where('expiry_date', '<', now())
        ->whereNull('deleted_at')
        ->whereHas('documentable', function ($query) {
            $query->whereNull('deleted_at');
        })
        ->get();

    return view('dashboard', [
        'expiredDocuments' => $expiredDocuments,
        'expiredDocumentsCount' => $expiredDocumentsCount,
        'expiringSoonCount' => $expiringSoonCount,
        'activeEmployeesCount' => $activeEmployeesCount,
        'operationalVehiclesCount' => $operationalVehiclesCount,
    ]);
})
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::get('/profile', [ProfileController::class, 'edit'])
    ->middleware(['auth'])
    ->name('profile.edit');

Route::patch('/profile', [ProfileController::class, 'update'])
    ->middleware(['auth'])
    ->name('profile.update');

Route::delete('/profile', [ProfileController::class, 'destroy'])
    ->middleware(['auth'])
    ->name('profile.destroy');

Route::group(['middleware' => 'auth'], function () {
    Route::get('/employees/{employee_id?}', EmployeeIndex::class)->name('employees.index');
    Route::get('/vehicles/{vehicle_id?}', VehicleIndex::class)->name('vehicles.index');
    Route::get('/customers', CustomerIndex::class)->name('customers.index'); // Add Customer route
    Route::get('/trips', TripIndex::class)->name('trips.index'); // Add Trip route
    Route::get('/settings/vehicle-types', VehicleTypeIndex::class)->name('settings.vehicle-types.index');
    Route::get('/settings/maintenance-types', MaintenanceTypeIndex::class)->name('settings.maintenance-types.index');
});

require __DIR__.'/auth.php';
